setwd("---")

library(tidyverse)
library(ggpubr)
library(rstatix)

df <- read.csv(file="hypt_Friedman_df_zero.csv", header=T, sep=",")

pulm_drug_22 <- c("ILOPROST",
                  "EPOPROSTENOL",
                  "SELEXIPAG",
                  "BERAPROST",
                  "CANDESARTAN",
                  "NIFEDIPINE",
                  "WARFARIN",
                  "BISOPROLOL",
                  "DILTIAZEM",
                  "HYDROCHLOROTHIAZIDE\\RAMIPRIL",
                  "IMIDAPRIL",
                  "LERCANIDIPINE",
                  "NICARDIPINE",
                  "TELMISARTAN",
                  "TORSEMIDE",
                  "AZELNIDIPINE",
                  "AZILSARTAN KAMEDOXOMIL",
                  "BENDROFLUMETHIAZIDE",
                  "BENIDIPINE",
                  "CILNIDIPINE",
                  "HYDROCHLOROTHIAZIDE\\VALSARTAN",
                  "METOPROLOL")

hlt_order <- c("PARENCHYMAL LUNG DISORDERS NEC",
               "PNEUMOTHORAX AND PLEURAL EFFUSIONS NEC",
               "LOWER RESPIRATORY TRACT INFLAMMATORY AND IMMUNOLOGIC CONDITIONS",
               "PULMONARY OEDEMAS",
               "BRONCHOSPASM AND OBSTRUCTION",
               "PULMONARY THROMBOTIC AND EMBOLIC CONDITIONS",
               "RESPIRATORY TRACT DISORDERS NEC",
               "COUGHING AND ASSOCIATED SYMPTOMS",
               "LOWER RESPIRATORY TRACT INFECTIONS NEC",
               "BREATHING ABNORMALITIES",
               "LOWER RESPIRATORY TRACT SIGNS AND SYMPTOMS",
               "RESPIRATORY FAILURES (EXCL NEONATAL)",
               "VASCULAR PULMONARY DISORDERS NEC",
               "BRONCHIAL CONDITIONS NEC",
               "FUNGAL LOWER RESPIRATORY TRACT INFECTIONS",
               "RESPIRATORY SYNCYTIAL VIRAL INFECTIONS",
               "RESPIRATORY SIGNS AND SYMPTOMS NEC",
               "RESPIRATORY TRACT INFECTIONS NEC",
               "PLEURAL INFECTIONS AND INFLAMMATIONS")

### get the hlt from EBGM data
data <- read.csv(file="suspicious_hypts_pulm_drug_hlt.csv", header=T, sep=",")
data_hlt <- data %>%
              filter(var1 %in% pulm_drug_22 & QUANT_05 > 1)
hlt_order_1 <- unique(data_hlt$var2)
match(hlt_order_1, hlt_order)

### data checking
remove_df <- df %>%
  filter(!(actsub == 'BERAPROST' & hlt == 'VASCULAR PULMONARY DISORDERS NEC'))%>%
  # filter(!(atc %in% c('ANTIHYPERTENSIVES', 'UROLOGICALS'))) %>%
  arrange(actsub)

### get the highest value for better visualization only
p <- ggboxplot(remove_df, x = "actsub", y = "ebgm", add = "jitter") +
  rotate_x_text(90)
p

atc_list <- unique(df$atc)
### glasso group
atc_list<- atc_list[-c(7)]

### atc 
for (i in atc_list){
  res.fried <- df %>%
    filter(group == 1) %>%
    filter(atc == i) %>%
    convert_as_factor(hlt, actsub) %>%
    friedman_test(ebgm ~ actsub | hlt)
  print(res.fried)
}

### glasso grouping
for (i in 1:6){
  res.fried <- df %>%
    filter(group == 1) %>%
    filter(glasso == i) %>%
    # filter(glasso == i, actsub != 'TADALAFIL') %>% ### 44 drug including UAs
    filter(glasso == i, actsub != 'WARFARIN') %>% ### 36 drugs without AHAs UAs
    convert_as_factor(hlt, actsub) %>%
    friedman_test(ebgm ~ actsub | hlt)
  print(res.fried)
}

# pairwise comparisons
pwc <- df %>%
  filter(group == 1) %>%
  filter(glasso == 1) %>%
  wilcox_test(ebgm ~ actsub, paired = TRUE, p.adjust.method = "hommel")
pwc

### atc grouping
atc_df <- df %>%
            filter(group == 1) %>%
              group_by(atc_abr, hlt) %>%
                get_summary_stats(ebgm, type = "common")

res.fried <- atc_df %>%
                friedman_test(mean ~ atc_abr | hlt)
print(res.fried)

pwc_atc <- atc_df %>%
  wilcox_test(mean ~ atc_abr, paired = TRUE, p.adjust.method = "bonferroni")
pwc_atc
# write.table(pwc_atc, 'atc_friedman_comparison.csv', sep = "$")

# Visualization: box plots with p-values
library(scales)
trans <- function(x) {
  ifelse(x > 12, x - 6.5, x)
}
inv <- function(x) {
  ifelse(x > 5, x + 6.5, x)
}
my_trans <- trans_new("my_trans", trans, inv)

pwc_atc <- pwc_atc %>% add_xy_position(x = "atc_abr")
p_comparison <- ggboxplot(atc_df, x = "atc_abr", y = "mean", add = "point",
                          xlab = 'Drug Class', ylab = 'EBGM Score') +
  # scale_y_continuous(trans = my_trans, breaks = seq(0, 7, by = 1)) +
  # scale_y_continuous(limits = c(0, 5)) +
  stat_pvalue_manual(pwc_atc, hide.ns = TRUE) +
  labs(
    subtitle = get_test_label(res.fried,  detailed = TRUE),
    caption = get_pwc_label(pwc_atc)
  ) +
  # rotate_x_text(90) +
  theme(text = element_text(size=28))
p_comparison

max(atc_df$mean)

### glasso group
glasso_df <- df %>%
              # mutate(ebgm = ebgm + 1)  %>%
              # filter(actsub != 'TADALAFIL') %>%
              # filter(actsub != 'WARFARIN') %>%
              filter(group == 1) %>%
              group_by(glasso, hlt) %>%
              get_summary_stats(ebgm, type = "common")
glasso_df$mean[glasso_df$mean > 2]

res.fried <- glasso_df %>%
  friedman_test(mean ~ glasso | hlt)
print(res.fried)

pwc_glasso <- glasso_df %>%
  wilcox_test(mean ~ glasso, paired = TRUE, p.adjust.method = "bonferroni")
pwc_glasso

# write.table(pwc_glasso, 'glasso_friedman_comparison_notada.csv', sep = "$")

# Visualization: box plots with p-values
# 4.8, 4.9, 0.5
pwc_glasso <- pwc_glasso %>% 
  add_xy_position(x = "glasso") %>%
  mutate(y.position = y.position - 4)
max(pwc_glasso$y.position)

pwc_glasso <- pwc_glasso %>%           
  mutate(y.position = ifelse(y.position > 5.5, y.position - 0.5, y.position))

# 8, 4, 3, 4,
trans <- function(x) {
  ifelse(x > 7, x - 3, x)
}
inv <- function(x) {
  ifelse(x > 3, x + 3, x)
}
my_trans <- trans_new("my_trans", trans, inv)

# (0,5)
p_comparison <- ggboxplot(glasso_df, x = "glasso", y = "mean", add = "point",
                          xlab = 'GLASSO Class', ylab = 'EBGM Score') +
  # scale_y_continuous(trans = my_trans, breaks = seq(0, 5, by = 1)) +
  stat_pvalue_manual(pwc_glasso, hide.ns = TRUE) +
  labs(
    subtitle = get_test_label(res.fried,  detailed = TRUE),
    caption = get_pwc_label(pwc_glasso)
  ) +
  theme(text = element_text(size=28))
p_comparison

library(gginnards)
which_layers(p, "GeomSignif")
your_font_size <- 10
p_comparison$layers[[which_layers(p_comparison, "GeomSignif")]]$aes_params$textsize <- your_font_size
p_comparison

glasso_df$mean[glasso_df$mean > 2]

ggsave(
  "./glasso_plot_1.pdf",
  width = 15,
  height = 10,
  scale = 1.1
)

### recheck within group differences
atc_list <- c(unique(df$atc))
atc_list <- atc_list[-c(6,7,8,9)]
for (i in atc_list){
  res.fried <- df %>%
    # filter(group == 1) %>%
    # filter(atc == i, actsub != 'TADALAFIL') %>%
    filter(atc == i) %>%
    # filter(atc == i) %>%
    convert_as_factor(hlt, actsub) %>%
    friedman_test(ebgm ~ actsub | hlt)
  print(i)
  print(res.fried)
}
